@extends('layouts.admin')
@section('title','Advertise Setting')
@section('content')
  <br>
  <div class="box-header">
  <h5>{{__('Advertise Settings')}}</h5>
</div>
    <div>

  <!-- Nav tabs -->
  <ul class="nav nav-tabs" role="tablist">
    <li role="presentation" class="active"><a href="#home1" aria-controls="home1" role="tab" data-toggle="tab">{{__('Advertise Setting')}}</a></li>
    <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab" data-toggle="tab">{{__('Skip AD Setting')}}</a></li>
    <li role="presentation"><a href="#profile" aria-controls="profile" role="tab" data-toggle="tab">{{__('Pop Up Ad Setting')}}</a></li>
    
  </ul>

  <!-- Tab panes -->
  <div class="tab-content">
      <div role="tabpanel" class="tab-pane fade in active" id="home1">
        <form action="{{ route('ad.update') }}" method="POST">
          {{ csrf_field() }}
          {{ method_field('PUT') }}
          <br>
          
          <div class="col-md-3">
            <div class="custom_toggle-checkbox form-group{{ $errors->has('remove_ads') ? ' has-error' : '' }}">
              <label class="text-dark">{{ __('Remove Ads') }} :</label><br>
              {!! Form::checkbox('remove_ads', 1, ($button->remove_ads == 1 ? 1 : 0), ['class' => 'custom_toggle']) !!}
              <small class="text-danger">{{ $errors->first('remove_ads') }}</small>
            </div>
          </div>
            
          </select>
      </div>
    <div role="tabpanel" class="tab-pane fade in active" id="home">
      <form action="{{ route('ad.update') }}" method="POST">
        {{ csrf_field() }}
        {{ method_field('PUT') }}
        <br>
        
        <label for="">{{__('Skip AD Timer')}}</label>
        <select name="timer_check" id="timer" class="form-control">
          <option value="no">{{__('No')}}</option>
          <option value="yes">{{__('Yes')}}</option>
          
        </select>
      <br>
      <div style="display: none;" id="t">
        <label for="time">{{__('Time : ')}}( Please Ensure that its not conflict with popup ad start time )</label>
        <input type="text" placeholder="00:00:10" name="ad_timer" class="form-control">
        <br>
        <label for="">{{__('Ad Hold Time:')}} </label>
        <input type="number" name="ad_hold" min="0" max="10" placeholder="eg. 5" class="form-control">
        </div>

        

        <input type="submit" value="Save" class="btn btn-md btn-success">
      </form>
    </div>

    <div role="tabpanel" class="fade tab-pane" id="profile">
      
        <form action="{{ route('ad.pop.update') }}" method="POST">
        {{ csrf_field() }}
        {{ method_field('PUT') }}
        <br>
        
        
        <label for="">{{__('Start Time:')}} <span class="help-block">( Please Ensure that its not conflict with video ad start time )</span></label>
        <input type="text" name="time" placeholder="00:00:10" class="form-control">
        <br>
        <label for="">{{__('End Time:')}} </label>
        <input type="text" name="endtime" placeholder="00:00:30" class="form-control">

        

        <input type="submit" value="Save" class="btn btn-md btn-success">
      </form>
    </div>

 
      
    </div>

</div>
  
  
@endsection
@section('custom-script')
  <script type="text/javascript">
    $('#timer').change(function(){
      if($(this).val() == 'no')
      {
        $('#t').hide();
      }else
      {
        $('#t').show();
      }
    });
  </script>
@endsection